/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.provisioning;

import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Util;
import oracle.ldap.util.provisioning.ProvisioningCmdArgs;
import oracle.ldap.util.provisioning.ProvisioningProfileV2;

public class ProvisioningProfile {
    protected String profileDN;
    protected String profileName;
    protected String profileStatus;
    protected String profileVersion = "2.0";
    protected String profileSchedule = "3600";
    protected String profileMaxRetries = "5";
    protected String profileGroup = "0";
    protected String profileInterfaceName;
    protected String profileInterfaceType;
    protected String profileInterfaceVersion;
    protected String profileInterfaceConnectInfo;
    protected Vector profileInterfaceAdditionalInfo;
    protected String profileChgLogLastAppliedChangeNumber;
    protected String profileChgLogSubscriberDisable;
    protected Vector provisioningProfileEventSubscription = null;
    protected String provisioningProfileAppName;
    protected String provisioningProfileAppGUID;
    protected String provisioningProfileOrgName;
    protected String provisioningProfileOrgGUID;
    protected String profileProcessingStatus;
    protected Vector profileProcessingErrors = null;
    protected String profileLastProcessingTime;
    protected String profileLastSuccessfulProcTime;
    protected static final char PARAM_NAME_VALUE_DELIM = '=';
    public static final String ATTR_ProfileName = "orclODIPProfileName";
    public static final String ATTR_Version = "orclVersion";
    public static final String ATTR_Status = "orclStatus";
    public static final String ATTR_PasswordAttribute = "orclPasswordAttribute";
    public static final String ATTR_userPassword = "userPassword";
    public static final String ATTR_Schedule = "orclODIPProfileSchedule";
    public static final String ATTR_MaxRetries = "orclODIPProfileMaxRetries";
    public static final String ATTR_ProfileGroup = "orclODIPProfileExecGroupID";
    public static final String ATTR_ProfileDebug = "orclODIPProfileDebugLevel";
    public static final String ATTR_IFName = "orclODIPProfileInterfaceName";
    public static final String ATTR_IFType = "orclODIPProfileInterfaceType";
    public static final String ATTR_IFConnectInfo = "orclODIPProfileInterfaceConnectInformation";
    public static final String ATTR_IFAdditionalInfo = "orclODIPProfileInterfaceAdditionalInformation";
    public static final String ATTR_IFVersion = "orclODIPProfileInterfaceVersion";
    public static final String ATTR_ProcStatus = "orclODIPProfileProcessingStatus";
    public static final String ATTR_ProcErrors = "orclODIPProfileProcessingErrors";
    public static final String ATTR_LastProcTime = "orclODIPProfileLastProcessingTime";
    public static final String ATTR_SuccProcTime = "orclODIPProfileLastSuccessfulProcessingTime";
    public static final String ATTR_ProvAppName = "orclODIPProvisioningAppName";
    public static final String ATTR_ProvAppGUID = "orclODIPProvisioningAppGUID";
    public static final String ATTR_ProvOrgName = "orclODIPProvisioningOrgName";
    public static final String ATTR_ProvOrgGUID = "orclODIPProvisioningOrgGUID";
    public static final String ATTR_ProvEvents = "orclODIPProvisioningEventSubscription";
    public static final String ATTR_LastChgNum = "orclLastAppliedChangeNumber";
    public static final String ATTR_SubscriberDisable = "orclSubscriberDisable";
    public static final String PROV_PROFILE_CONTAINER = "cn=Provisioning Profiles, cn=Changelog Subscriber, cn=Oracle Internet Directory";
    public static final String PROV_PROFILE_VERSION = "1.0";
    public static final String ERROR_PREFIX = "ERROR: ";
    protected static String NEW_LINE = System.getProperty("line.separator");
    protected static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    public static boolean apimode = true;

    public ProvisioningProfile() {
    }

    public ProvisioningProfile(DirContext dirContext, String string) throws Exception {
        this.readProfileFromDirectory(dirContext, string);
    }

    public ProvisioningProfile(DirContext dirContext, String string, String string2) throws Exception {
        String string3 = ProvisioningProfile.composeProfileDN(dirContext, string, string2);
        this.readProfileFromDirectory(dirContext, string3);
    }

    public static String getOIDVersion(DirContext dirContext) throws Exception {
        try {
            RootOracleContext rootOracleContext = new RootOracleContext(dirContext);
            String string = rootOracleContext.getVersion(dirContext);
            ProvisioningCmdArgs.LOG("OID Version :" + string);
            return string;
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public static void ProfileHandler(String[] stringArray) throws Exception {
        Object var1_1 = null;
        ProvisioningCmdArgs provisioningCmdArgs = null;
        DirContext dirContext = null;
        try {
            provisioningCmdArgs = new ProvisioningCmdArgs(stringArray);
            provisioningCmdArgs.validateCmdArgs();
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new Exception(invalidParameterException.getMessage());
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
        dirContext = ProvisioningProfile.getJNDIConnection(provisioningCmdArgs.get("LDAP_HOST"), provisioningCmdArgs.get("LDAP_PORT"), provisioningCmdArgs.get("LDAP_USER_DN"), provisioningCmdArgs.get("LDAP_USER_PASSWORD"), provisioningCmdArgs.get("SSL_MODE"));
        String string = ProvisioningProfile.getOIDVersion(dirContext);
        if (string.compareTo("90400") < 0) {
            String string2 = provisioningCmdArgs.get("INTERFACE_VERSION");
            if (string2.equals("2.0")) {
                ProvisioningCmdArgs.LOG("Forcing interface vers to 1.1 for pre 904 ");
                provisioningCmdArgs.put("INTERFACE_VERSION", "1.1");
                provisioningCmdArgs.put("PROFILE_VERSION", PROV_PROFILE_VERSION);
            }
        }
        provisioningCmdArgs.computeDefaultValues(dirContext);
        ProvisioningProfile.manageProfiles(dirContext, provisioningCmdArgs);
    }

    public static void ProfileHandler(DirContext dirContext, String[] stringArray) throws Exception {
        Object var2_2 = null;
        ProvisioningCmdArgs provisioningCmdArgs = null;
        try {
            provisioningCmdArgs = new ProvisioningCmdArgs(stringArray);
            provisioningCmdArgs.validateCmdArgs();
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new Exception(invalidParameterException.getMessage());
        }
        catch (Exception exception) {
            throw new Exception(exception.toString());
        }
        if (dirContext == null) {
            throw new Exception("Invalid LDAP Handle Passed..");
        }
        String string = ProvisioningProfile.getOIDVersion(dirContext);
        if (string.compareTo("90400") < 0) {
            String string2 = provisioningCmdArgs.get("INTERFACE_VERSION");
            if (string2.equals("2.0")) {
                ProvisioningCmdArgs.LOG("Forcing interface vers to 1.1 for pre 904 ");
                provisioningCmdArgs.put("INTERFACE_VERSION", "1.1");
                provisioningCmdArgs.put("PROFILE_VERSION", PROV_PROFILE_VERSION);
            }
        }
        provisioningCmdArgs.computeDefaultValues(dirContext);
        ProvisioningProfile.manageProfiles(dirContext, provisioningCmdArgs);
    }

    public void checkIntfVersion(ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        String string = this.getProfileInterfaceVersion();
        String string2 = provisioningCmdArgs.get("INTERFACE_VERSION");
        if (!string.equalsIgnoreCase(string2)) {
            throw new Exception(resBundle.getString("PROV_INTERFACE_MISMATCH") + " - " + string);
        }
    }

    private static void manageProfiles(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        block41: {
            String string = "";
            String string2 = ProvisioningProfile.composeProfileDN(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
            if (!apimode) {
                System.out.println(string2);
            }
            String string3 = provisioningCmdArgs.get("PROFILE_VERSION");
            if (string3.equals("2.0")) {
                ProvisioningProfileV2.processV2(dirContext, provisioningCmdArgs);
                break block41;
            }
            ProvisioningProfile provisioningProfile = null;
            switch (provisioningCmdArgs.getOperation()) {
                case 1: {
                    try {
                        provisioningProfile = ProvisioningProfile.createNewProfile(dirContext, provisioningCmdArgs);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_SUCCESS"));
                            System.out.println("Profile Name : " + provisioningProfile.getProfileName());
                        }
                        break;
                    }
                    catch (Exception exception) {
                        string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_FAILURE");
                        if (!apimode) {
                            System.out.println(string);
                            break;
                        }
                        throw new Exception(string);
                    }
                }
                case 2: {
                    try {
                        provisioningProfile = new ProvisioningProfile(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                        provisioningProfile.checkIntfVersion(provisioningCmdArgs);
                        provisioningProfile.disable(dirContext);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_DISABLED"));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_MOD_FAILURE");
                        if (!apimode) {
                            System.out.println(string);
                            break;
                        }
                        throw new Exception(string);
                    }
                }
                case 3: {
                    try {
                        provisioningProfile = new ProvisioningProfile(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                        provisioningProfile.checkIntfVersion(provisioningCmdArgs);
                        provisioningProfile.enable(dirContext);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_ENABLED"));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_MOD_FAILURE");
                        if (!apimode) {
                            System.out.println(string);
                            break;
                        }
                        throw new Exception(string);
                    }
                }
                case 4: {
                    try {
                        provisioningProfile = new ProvisioningProfile(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                        provisioningProfile.checkIntfVersion(provisioningCmdArgs);
                        provisioningProfile.status(dirContext);
                        break;
                    }
                    catch (Exception exception) {
                        string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_NO_STATUS");
                        if (!apimode) {
                            System.out.println(string);
                            break;
                        }
                        throw new Exception(string);
                    }
                }
                case 5: {
                    try {
                        provisioningProfile = new ProvisioningProfile(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                        provisioningProfile.checkIntfVersion(provisioningCmdArgs);
                        provisioningProfile.delete(dirContext);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_DELETED"));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_DELETE_FAILURE");
                        if (!apimode) {
                            System.out.println(string);
                            break;
                        }
                        throw new Exception(string);
                    }
                }
                case 6: {
                    try {
                        provisioningProfile = new ProvisioningProfile(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                        provisioningProfile.checkIntfVersion(provisioningCmdArgs);
                        provisioningProfile.reset(dirContext);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_RESET_SUCCESS"));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_RESET_FAILURE");
                        if (!apimode) {
                            System.out.println(string);
                            break;
                        }
                        throw new Exception(string);
                    }
                }
                case 7: {
                    try {
                        provisioningProfile = new ProvisioningProfile(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
                        provisioningProfile.checkIntfVersion(provisioningCmdArgs);
                        provisioningProfile.modify(dirContext, provisioningCmdArgs);
                        if (!apimode) {
                            System.out.println(resBundle.getString("PROV_PROFILE_MOD_SUCCESS"));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        string = ProvisioningProfile.getResultStr(exception, "PROV_PROFILE_MOD_FAILURE");
                        if (!apimode) {
                            System.out.println(string);
                            break;
                        }
                        throw new Exception(string);
                    }
                }
                default: {
                    if (!apimode) {
                        System.out.println("Invalid Operation");
                        break;
                    }
                    throw new Exception("Invalid Operation argument!! ");
                }
            }
        }
    }

    public static String getResultStr(Exception exception, String string) {
        String string2 = ERROR_PREFIX + exception.getMessage() + "\n" + resBundle.getString(string);
        return string2;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            apimode = false;
            ProvisioningProfile.ProfileHandler(stringArray);
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void modify(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        String string;
        Vector vector;
        Vector vector2;
        int n = 0;
        ModificationItem[] modificationItemArray = new ModificationItem[32];
        BasicAttribute basicAttribute = null;
        if (provisioningCmdArgs.get("SCHEDULE") != null) {
            int n2 = n++;
            modificationItemArray[n2] = new ModificationItem(2, new BasicAttribute(ATTR_Schedule, provisioningCmdArgs.get("SCHEDULE")));
        }
        if (provisioningCmdArgs.get("MAX_RETRIES") != null) {
            int n3 = n++;
            modificationItemArray[n3] = new ModificationItem(2, new BasicAttribute(ATTR_MaxRetries, provisioningCmdArgs.get("MAX_RETRIES")));
        }
        if (provisioningCmdArgs.get("INTERFACE_NAME") != null) {
            int n4 = n++;
            modificationItemArray[n4] = new ModificationItem(2, new BasicAttribute(ATTR_IFName, provisioningCmdArgs.get("INTERFACE_NAME")));
        }
        if (provisioningCmdArgs.get("INTERFACE_TYPE") != null) {
            int n5 = n++;
            modificationItemArray[n5] = new ModificationItem(2, new BasicAttribute(ATTR_IFType, provisioningCmdArgs.get("INTERFACE_TYPE")));
        }
        if (provisioningCmdArgs.get("INTERFACE_CONNECT_INFO") != null) {
            int n6 = n++;
            modificationItemArray[n6] = new ModificationItem(2, new BasicAttribute(ATTR_IFConnectInfo, provisioningCmdArgs.get("INTERFACE_CONNECT_INFO")));
        }
        if (provisioningCmdArgs.get("PROFILE_GROUP") != null) {
            int n7 = n++;
            modificationItemArray[n7] = new ModificationItem(2, new BasicAttribute(ATTR_ProfileGroup, provisioningCmdArgs.get("PROFILE_GROUP")));
        }
        if (provisioningCmdArgs.get("PROFILE_DEBUG") != null) {
            int n8 = n++;
            modificationItemArray[n8] = new ModificationItem(2, new BasicAttribute(ATTR_ProfileDebug, provisioningCmdArgs.get("PROFILE_DEBUG")));
        }
        if ((vector2 = provisioningCmdArgs.getVector("INTERFACE_ADDITIONAL_INFO")) != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclODIPProfileInterfaceAdditionalInformation");
            basicAttribute = new BasicAttribute(ATTR_IFAdditionalInfo);
            int n9 = 0;
            while (n9 < vector2.size()) {
                basicAttribute.add(vector2.elementAt(n9));
                ++n9;
            }
            modificationItemArray[n++] = new ModificationItem(2, basicAttribute);
        }
        if ((vector = provisioningCmdArgs.getVector("EVENT_SUBSCRIPTION")) != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclODIPProvisioningEventSubscription");
            basicAttribute = new BasicAttribute(ATTR_ProvEvents);
            int n10 = 0;
            while (n10 < vector.size()) {
                basicAttribute.add(vector.elementAt(n10));
                ++n10;
            }
            modificationItemArray[n++] = new ModificationItem(2, basicAttribute);
        }
        if ((string = provisioningCmdArgs.get("LASTCHANGENUMBER")) != null) {
            ProvisioningCmdArgs.LOG("Updating Attribute :orclLastAppliedChangeNumber");
            basicAttribute = new BasicAttribute(ATTR_LastChgNum);
            basicAttribute.add(string);
            modificationItemArray[n++] = new ModificationItem(2, new BasicAttribute(ATTR_LastChgNum, basicAttribute));
        }
        if (n == 0) {
            ProvisioningCmdArgs.LOG("Nothing TO modify in Profile");
        }
        ModificationItem[] modificationItemArray2 = new ModificationItem[n];
        System.arraycopy(modificationItemArray, 0, modificationItemArray2, 0, n);
        ProvisioningCmdArgs.LOG("Modifying entry : (" + this.profileDN + ")");
        dirContext.modifyAttributes(this.profileDN, modificationItemArray2);
    }

    public void disable(DirContext dirContext) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("DISABLED")) {
            System.out.println(resBundle.getString("PROV_PROFILE_ALREADY_DISABLED"));
        }
        ModificationItem[] modificationItemArray = new ModificationItem[1];
        modificationItemArray[0] = new ModificationItem(2, new BasicAttribute(ATTR_Status, "DISABLED"));
        dirContext.modifyAttributes(this.profileDN, modificationItemArray);
    }

    public void enable(DirContext dirContext) throws Exception {
        if (this.getProfileStatus().equalsIgnoreCase("ENABLED")) {
            System.out.println(resBundle.getString("PROV_PROFILE_ALREADY_ENABLED"));
        }
        ModificationItem[] modificationItemArray = new ModificationItem[1];
        modificationItemArray[0] = new ModificationItem(2, new BasicAttribute(ATTR_Status, "ENABLED"));
        dirContext.modifyAttributes(this.profileDN, modificationItemArray);
    }

    public void reset(DirContext dirContext) throws Exception {
        ModificationItem[] modificationItemArray = new ModificationItem[1];
        if (this.getProfileProcessingErrors() != null) {
            modificationItemArray[0] = new ModificationItem(3, new BasicAttribute(ATTR_ProcErrors));
            dirContext.modifyAttributes(this.profileDN, modificationItemArray);
        }
    }

    public void delete(DirContext dirContext) throws Exception {
        dirContext.destroySubcontext(this.profileDN);
        ProvisioningCmdArgs.LOG("Profile has been successfully deleted");
    }

    public void status(DirContext dirContext) throws Exception {
        String[] stringArray = new String[]{"*", "orclguid"};
        Property property = null;
        PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, this.profileDN, "objectclass=*", 0, stringArray);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        property = propertySet.getProperty(ATTR_LastChgNum);
        if (property != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)property.getValue(0));
            System.out.println(ATTR_LastChgNum + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_SubscriberDisable)) != null) {
            this.setProfileChgLogSubscriberDisable((String)property.getValue(0));
            System.out.println(ATTR_SubscriberDisable + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProcStatus)) != null) {
            this.setProfileProcessingStatus((String)property.getValue(0));
            System.out.println(ATTR_ProcStatus + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProcErrors)) != null && property.size() > 0) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                System.out.println(ATTR_ProcErrors + ": " + (String)property.getValue(0));
                ++n;
            }
            this.setProfileProcessingErrors(vector);
        }
        if ((property = propertySet.getProperty(ATTR_LastProcTime)) != null) {
            this.setProfileLastProcessingTime((String)property.getValue(0));
            System.out.println(ATTR_LastProcTime + ": " + (String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_SuccProcTime)) != null) {
            this.setProfileLastSuccessfulProcTime((String)property.getValue(0));
            System.out.println(ATTR_SuccProcTime + ": " + (String)property.getValue(0));
        }
    }

    public static ProvisioningProfile createNewProfile(DirContext dirContext, ProvisioningCmdArgs provisioningCmdArgs) throws Exception {
        ProvisioningProfile provisioningProfile = null;
        boolean bl = false;
        Object var4_4 = null;
        Vector vector = null;
        Vector vector2 = null;
        String string = ProvisioningProfile.composeProfileDN(dirContext, provisioningCmdArgs.get("APPLICATION_DN"), provisioningCmdArgs.get("ORGANIZATION_DN"));
        bl = ProvisioningProfile.directoryEntryExists(dirContext, string);
        if (!bl) {
            int n;
            BasicAttribute basicAttribute = null;
            BasicAttributes basicAttributes = new BasicAttributes();
            BasicAttribute basicAttribute2 = new BasicAttribute("objectclass");
            basicAttribute2.add("top");
            basicAttribute2.add("orclODIPProvisioningIntegrationProfile");
            basicAttribute2.add("orclChangeSubscriber");
            basicAttributes.put(basicAttribute2);
            basicAttribute = new BasicAttribute(ATTR_ProfileName);
            basicAttribute.add(ProvisioningProfile.getRDNAttrValue(dirContext, string));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_Version);
            basicAttribute.add(PROV_PROFILE_VERSION);
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_Status);
            basicAttribute.add(provisioningCmdArgs.get("PROFILE_STATUS"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_ProvAppName);
            basicAttribute.add(ProvisioningProfile.getRDNAttrValue(dirContext, provisioningCmdArgs.get("APPLICATION_DN")));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_ProvOrgName);
            basicAttribute.add(ProvisioningProfile.getRDNAttrValue(dirContext, provisioningCmdArgs.get("ORGANIZATION_DN")));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_ProvAppGUID);
            basicAttribute.add(ProvisioningProfile.getDirectoryEntryGUID(dirContext, provisioningCmdArgs.get("APPLICATION_DN")));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_ProvOrgGUID);
            basicAttribute.add(ProvisioningProfile.getDirectoryEntryGUID(dirContext, provisioningCmdArgs.get("ORGANIZATION_DN")));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_Schedule);
            basicAttribute.add(provisioningCmdArgs.get("SCHEDULE"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_MaxRetries);
            basicAttribute.add(provisioningCmdArgs.get("MAX_RETRIES"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_ProfileGroup);
            basicAttribute.add(provisioningCmdArgs.get("PROFILE_GROUP"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_ProfileDebug);
            basicAttribute.add(provisioningCmdArgs.get("PROFILE_DEBUG"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_IFName);
            basicAttribute.add(provisioningCmdArgs.get("INTERFACE_NAME"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_IFType);
            basicAttribute.add(provisioningCmdArgs.get("INTERFACE_TYPE"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_IFVersion);
            basicAttribute.add(provisioningCmdArgs.get("INTERFACE_VERSION"));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_IFConnectInfo);
            basicAttribute.add(provisioningCmdArgs.get("INTERFACE_CONNECT_INFO"));
            basicAttributes.put(basicAttribute);
            vector2 = provisioningCmdArgs.getVector("INTERFACE_ADDITIONAL_INFO");
            if (vector2 != null) {
                basicAttribute = new BasicAttribute(ATTR_IFAdditionalInfo);
                n = 0;
                while (n < vector2.size()) {
                    basicAttribute.add((String)vector2.elementAt(n));
                    ++n;
                }
                basicAttributes.put(basicAttribute);
            }
            if ((vector = provisioningCmdArgs.getVector("EVENT_SUBSCRIPTION")) != null) {
                basicAttribute = new BasicAttribute(ATTR_ProvEvents);
                n = 0;
                while (n < vector.size()) {
                    basicAttribute.add((String)vector.elementAt(n));
                    ++n;
                }
                basicAttributes.put(basicAttribute);
            }
            basicAttribute = new BasicAttribute(ATTR_LastChgNum);
            basicAttribute.add(ProvisioningProfile.getCurrentChangeNumber(dirContext));
            basicAttributes.put(basicAttribute);
            basicAttribute = new BasicAttribute(ATTR_SubscriberDisable);
            basicAttribute.add("0");
            basicAttributes.put(basicAttribute);
            DirContext dirContext2 = dirContext.createSubcontext(string, (Attributes)basicAttributes);
            provisioningProfile = new ProvisioningProfile(dirContext, string);
            if (!apimode) {
                System.out.println("Application : " + provisioningProfile.getProvisioningProfileAppName());
                System.out.println("Organization : " + provisioningProfile.getProvisioningProfileOrgName());
                System.out.println("Status : " + provisioningProfile.getProfileStatus());
                System.out.println("Schedule : " + provisioningProfile.getProfileSchedule());
                System.out.println("Retries : " + provisioningProfile.getProfileMaxRetries());
                System.out.println("Execution Group : " + provisioningProfile.getProfileGroup());
                System.out.println("Interface Name : " + provisioningProfile.getProfileInterfaceName());
                System.out.println("Interface Type : " + provisioningProfile.getProfileInterfaceType());
                System.out.println("Interface Version : " + provisioningProfile.getProfileInterfaceVersion());
                System.out.println("Interface Connection Info : ---");
                System.out.println("Interface Additional Info : " + provisioningProfile.getProfileInterfaceAdditionalInfo());
                System.out.println("Last Applied Change Number : " + provisioningProfile.getProfileChgLogLastAppliedChangeNumber());
                System.out.println("Event Subscriptions : " + provisioningProfile.getProvisioningProfileEventSubscription());
            }
            return provisioningProfile;
        }
        throw new Exception("Provisioning Profile Already Exists..");
    }

    private void readProfileFromDirectory(DirContext dirContext, String string) throws Exception {
        int n;
        Vector<Object> vector;
        String[] stringArray = new String[]{"*", "orclguid"};
        Property property = null;
        PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, string, "objectclass=*", 0, stringArray);
        PropertySet propertySet = propertySetCollection.getPropertySet(0);
        this.profileDN = string;
        property = propertySet.getProperty(ATTR_ProfileName);
        if (property != null) {
            this.setProfileName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_Status)) != null) {
            this.setProfileStatus((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_Version)) != null) {
            this.setProfileVersion((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_Schedule)) != null) {
            this.setProfileSchedule((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_MaxRetries)) != null) {
            this.setProfileMaxRetries((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProfileGroup)) != null) {
            this.setProfileGroup((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_IFName)) != null) {
            this.setProfileInterfaceName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_IFType)) != null) {
            this.setProfileInterfaceType((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_IFVersion)) != null) {
            this.setProfileInterfaceVersion((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_IFConnectInfo)) != null) {
            this.setProfileInterfaceConnectInfo((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_LastChgNum)) != null) {
            this.setProfileChgLogLastAppliedChangeNumber((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_SubscriberDisable)) != null) {
            this.setProfileChgLogSubscriberDisable((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_IFAdditionalInfo)) != null && property.size() > 0) {
            vector = new Vector<Object>();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProfileInterfaceAdditionalInfo(vector);
        }
        if ((property = propertySet.getProperty(ATTR_ProvEvents)) != null && property.size() > 0) {
            vector = new Vector();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProvisioningProfileEventSubscription(vector);
        }
        if ((property = propertySet.getProperty(ATTR_ProvAppName)) != null) {
            this.setProvisioningProfileAppName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProvAppGUID)) != null) {
            this.setProvisioningProfileAppGUID((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProvOrgName)) != null) {
            this.setProvisioningProfileOrgName((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProvOrgGUID)) != null) {
            this.setProvisioningProfileOrgGUID((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProcStatus)) != null) {
            this.setProfileProcessingStatus((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_ProcErrors)) != null && property.size() > 0) {
            vector = new Vector();
            n = 0;
            while (n < property.size()) {
                vector.addElement(property.getValue(n));
                ++n;
            }
            this.setProfileProcessingErrors(vector);
        }
        if ((property = propertySet.getProperty(ATTR_LastProcTime)) != null) {
            this.setProfileLastProcessingTime((String)property.getValue(0));
        }
        if ((property = propertySet.getProperty(ATTR_SuccProcTime)) != null) {
            this.setProfileLastSuccessfulProcTime((String)property.getValue(0));
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public String getProfileStatus() {
        return this.profileStatus;
    }

    public void setProfileStatus(String string) {
        this.profileStatus = string;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String string) {
        this.profileVersion = string;
    }

    public String getProfileSchedule() {
        return this.profileSchedule;
    }

    public void setProfileSchedule(String string) {
        this.profileSchedule = string;
    }

    public String getProfileMaxRetries() {
        return this.profileMaxRetries;
    }

    public void setProfileMaxRetries(String string) {
        this.profileMaxRetries = string;
    }

    public String getProfileGroup() {
        return this.profileGroup;
    }

    public void setProfileGroup(String string) {
        this.profileGroup = string;
    }

    public String getProfileInterfaceName() {
        return this.profileInterfaceName;
    }

    public void setProfileInterfaceName(String string) {
        this.profileInterfaceName = string;
    }

    public String getProfileInterfaceType() {
        return this.profileInterfaceType;
    }

    public void setProfileInterfaceType(String string) {
        this.profileInterfaceType = string;
    }

    public String getProfileInterfaceVersion() {
        return this.profileInterfaceVersion;
    }

    public void setProfileInterfaceVersion(String string) {
        this.profileInterfaceVersion = string;
    }

    public String getProfileInterfaceConnectInfo() {
        return this.profileInterfaceConnectInfo;
    }

    public void setProfileInterfaceConnectInfo(String string) {
        this.profileInterfaceConnectInfo = string;
    }

    public String getProfileChgLogLastAppliedChangeNumber() {
        return this.profileChgLogLastAppliedChangeNumber;
    }

    public void setProfileChgLogLastAppliedChangeNumber(String string) {
        this.profileChgLogLastAppliedChangeNumber = string;
    }

    public String getProfileChgLogSubscriberDisable() {
        return this.profileChgLogSubscriberDisable;
    }

    public void setProfileChgLogSubscriberDisable(String string) {
        this.profileChgLogSubscriberDisable = string;
    }

    public Vector getProfileInterfaceAdditionalInfo() {
        return this.profileInterfaceAdditionalInfo;
    }

    public void setProfileInterfaceAdditionalInfo(Vector vector) {
        this.profileInterfaceAdditionalInfo = vector;
    }

    public Vector getProvisioningProfileEventSubscription() {
        return this.provisioningProfileEventSubscription;
    }

    public void setProvisioningProfileEventSubscription(Vector vector) {
        this.provisioningProfileEventSubscription = vector;
    }

    public String getProvisioningProfileAppName() {
        return this.provisioningProfileAppName;
    }

    public void setProvisioningProfileAppName(String string) {
        this.provisioningProfileAppName = string;
    }

    public String getProvisioningProfileAppGUID() {
        return this.provisioningProfileAppGUID;
    }

    public void setProvisioningProfileAppGUID(String string) {
        this.provisioningProfileAppGUID = string;
    }

    public String getProvisioningProfileOrgName() {
        return this.provisioningProfileOrgName;
    }

    public void setProvisioningProfileOrgName(String string) {
        this.provisioningProfileOrgName = string;
    }

    public String getProvisioningProfileOrgGUID() {
        return this.provisioningProfileOrgGUID;
    }

    public void setProvisioningProfileOrgGUID(String string) {
        this.provisioningProfileOrgGUID = string;
    }

    public String getProfileProcessingStatus() {
        return this.profileProcessingStatus;
    }

    public void setProfileProcessingStatus(String string) {
        this.profileProcessingStatus = string;
    }

    public Vector getProfileProcessingErrors() {
        return this.profileProcessingErrors;
    }

    public void setProfileProcessingErrors(Vector vector) {
        this.profileProcessingErrors = vector;
    }

    public String getProfileLastProcessingTime() {
        return this.profileLastProcessingTime;
    }

    public void setProfileLastProcessingTime(String string) {
        this.profileLastProcessingTime = string;
    }

    public String getProfileLastSuccessfulProcTime() {
        return this.profileLastSuccessfulProcTime;
    }

    public void setProfileLastSuccessfulProcTime(String string) {
        this.profileLastSuccessfulProcTime = string;
    }

    public static DirContext getJNDIConnection(String string, String string2, String string3, String string4, String string5) throws Exception {
        InitialDirContext initialDirContext;
        block6: {
            initialDirContext = null;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", "ldap://" + string + ":" + string2);
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", string3);
            hashtable.put("java.naming.security.credentials", string4);
            int n = 0;
            try {
                n = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                n = 0;
            }
            if (n >= 1) {
                Properties properties = System.getProperties();
                properties.put("SSLSocketFactoryImplClass", "oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl");
                hashtable.put("java.naming.ldap.factory.socket", "oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl");
                hashtable.put("java.naming.security.protocol", "ssl");
            }
            try {
                initialDirContext = new InitialDirContext(hashtable);
            }
            catch (NamingException namingException) {
                if (namingException instanceof CommunicationException) {
                    throw new Exception(ERROR_PREFIX + resBundle.getString("PROV_PROFILE_CONN_ERR"));
                }
                if (!(namingException instanceof AuthenticationException)) break block6;
                throw new Exception(ERROR_PREFIX + resBundle.getString("PROV_PROFILE_AUTH_ERR"));
            }
        }
        return initialDirContext;
    }

    public static String getDirectoryEntryGUID(DirContext dirContext, String string) {
        Object object;
        PropertySetCollection propertySetCollection = null;
        try {
            object = new String[]{"orclguid"};
            propertySetCollection = Util.getEntryDetails(dirContext, string, "(objectclass=*)", 0, (String[])object);
        }
        catch (NamingException namingException) {
            System.out.println("Unable to get GUID of entry: " + string);
            System.out.println(namingException);
            return null;
        }
        object = propertySetCollection.getPropertySet(string);
        Property property = ((PropertySet)object).getProperty("orclguid");
        Object object2 = property.getValue(0);
        if (object2 instanceof byte[]) {
            return new String((byte[])object2);
        }
        return (String)object2;
    }

    public static String composeProfileDN(DirContext dirContext, String string, String string2) throws Exception {
        String string3 = ProvisioningProfile.getDirectoryEntryGUID(dirContext, string);
        String string4 = ProvisioningProfile.getDirectoryEntryGUID(dirContext, string2);
        if (string3 == null) {
            throw new Exception("Unable to locate application.. ");
        }
        if (string4 == null) {
            throw new Exception("Unable to locate organization.. ");
        }
        return new String("orclODIPProfileName=" + string4 + "_" + string3 + ", " + PROV_PROFILE_CONTAINER);
    }

    public static String getRDNAttrValue(DirContext dirContext, String string) {
        try {
            String string2 = Util.normalizeDN(string);
            NameParser nameParser = dirContext.getNameParser("");
            Name name = nameParser.parse(string2);
            String string3 = name.get(name.size() - 1);
            int n = string3.indexOf(61);
            String string4 = string3.substring(n + 1).trim();
            return string4;
        }
        catch (Exception exception) {
            return "Unknown";
        }
    }

    public static String getCurrentChangeNumber(DirContext dirContext) {
        try {
            String[] stringArray = new String[]{"lastchangenumber"};
            PropertySetCollection propertySetCollection = Util.getEntryDetails(dirContext, "", "(objectclass=*)", 0, stringArray);
            PropertySet propertySet = propertySetCollection.getPropertySet(0);
            Property property = propertySet.getProperty("lastchangenumber");
            Object object = property.getValue(0);
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean directoryEntryExists(DirContext dirContext, String string) {
        block3: {
            String[] stringArray = new String[]{"orclguid"};
            PropertySetCollection propertySetCollection = null;
            try {
                propertySetCollection = Util.getEntryDetails(dirContext, string, "objectclass=*", 0, null);
            }
            catch (Exception exception) {
                if (exception instanceof NameNotFoundException) {
                    return false;
                }
                if (!(exception instanceof NameNotFoundException)) break block3;
                System.out.println(exception);
                return false;
            }
        }
        return true;
    }
}

